<?php

use App\Http\Controllers\LocalizationController;
use App\Http\Controllers\User\HomeController;
use App\Http\Controllers\User\UserAuthController;
use App\Http\Controllers\User\UserBloodRequestController;
use App\Http\Controllers\User\UserFoundationController;
use App\Http\Controllers\User\UserDashboardController;
use App\Models\BloodRequestMessage;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

// Route::get('/', function () {
//     return view('frontend.pages.profile');
// });

Route::get('setLocale', [LocalizationController::class, 'setLocale'])->name('app.setlocale');

Route::get('/', [UserAuthController::class, 'home'])->name('home');

Route::get('/login', [UserAuthController::class, 'login'])->name('login');
Route::post('login', [UserAuthController::class, 'store_login'])->name('login.store');
Route::get('/FoundationLogin.html', [UserAuthController::class, 'foundationlogin'])->name('foundationlogin');
Route::get('/project/education', [HomeController::class, 'Education'])->name('education');
Route::get('/project/health', [HomeController::class, 'Health'])->name('health');
Route::get('/project/food-for-all', [HomeController::class, 'FoodForAll'])->name('food_for_all');
Route::get('/entrepreneur', [HomeController::class, 'Entrepreneur'])->name('entrepreneur');
Route::get('/about', [HomeController::class, 'about'])->name('about');
Route::get('/privacy-policy', [HomeController::class, 'privacyPolicy'])->name('privacyPolicy');
Route::get('/trams-condition', [HomeController::class, 'tramsCondition'])->name('tramsCondition');
Route::get('/contact-us', [HomeController::class, 'contactUs'])->name('contact.us');
Route::get('/galleries', [HomeController::class, 'gallery'])->name('galleries');
Route::get('/gallery/{id}', [HomeController::class, 'gallerySingle'])->name('gallerySingle');



Route::post('/login', [\App\Http\Controllers\User\UserAuthController::class, 'store_login'])->name('store_login');
Route::post('/foundation_store_login', [\App\Http\Controllers\User\UserAuthController::class, 'foundation_store_login'])->name('foundation_store_login');

Route::get('register', [\App\Http\Controllers\User\UserAuthController::class, 'register'])->name('register');
Route::get('registation.html', [\App\Http\Controllers\User\UserAuthController::class, 'foundationregister'])->name('foundatin_register');
Route::post('foundation_store_register', [\App\Http\Controllers\User\UserAuthController::class, 'foundation_store_register'])->name('foundation_store_register');
Route::post('store_register', [\App\Http\Controllers\User\UserAuthController::class, 'store_register'])->name('store_register');
// Verify OTP
Route::get('verify-otp', [\App\Http\Controllers\User\UserAuthController::class, 'verifyOtp'])->name('verify.otp');
Route::post('verify-otp-match', [\App\Http\Controllers\User\UserAuthController::class, 'verifyOtpMatch'])->name('verify.otp.match');
Route::post('resend-otp', [\App\Http\Controllers\User\UserAuthController::class, 'resendOtp'])->name('resend.otp');


// Route::group(['middleware' => 'auth'], function () {
//     Route::get('logout', [\App\Http\Controllers\User\UserAuthController::class, 'logout'])->name('logout');
//     Route::get('dashboard', [UserDashboardController::class, 'index'])->name('dashboard');
//     // Route::get('profile', [\App\Http\Controllers\User\UserProfileController::class, 'index'])->name('userProfile');
//     // Route::post('profile.create', [\App\Http\Controllers\User\UserProfileController::class, 'createProfile'])->name('userProfile');
//     Route::post('profile.create', [\App\Http\Controllers\User\UserProfileController::class, 'createProfile'])->name('profile.create');
//     Route::put('update-profile-image', [\App\Http\Controllers\User\UserProfileController::class, 'updateProfileImage'])->name('update.profile.image');

//     Route::get('profile', [\App\Http\Controllers\User\UserProfileController::class, 'index'])->name('userProfile');
//     Route::get('blood_request', [\App\Http\Controllers\User\UserProfileController::class, 'blood_request'])->name('bloodRequest');
//     Route::post('blood_request_upload', [\App\Http\Controllers\User\UserProfileController::class, 'blood_request_upload'])->name('bloodRequestUpload');
//     Route::get('contact_foundation/{id}', [UserFoundationController::class, 'contactFoundation'])->name('contactFoundation');
//     Route::post('contact_foundation_upload/{f_id}', [UserFoundationController::class, 'contactFoundationUpload'])->name('contactFoundationUpload');

//     //  User Profile

//     Route::get('Birthplace/Division/dist', [\App\Http\Controllers\User\UserProfileController::class, 'DivisionByDist']);
//     Route::get('Birthplace/Districts/Upzilla', [\App\Http\Controllers\User\UserProfileController::class, 'DistrictsByUpzilla']);
//     Route::get('Birthplace/Upzilla/Union', [\App\Http\Controllers\User\UserProfileController::class, 'UpzillaByUnion']);
//     Route::get('Birthplace/Union/Ward/', [\App\Http\Controllers\User\UserProfileController::class, 'UnionByWard']);
//     Route::get('Birthplace/Ward/vallage', [\App\Http\Controllers\User\UserProfileController::class, 'WardByVallage']);
// });


Route::group(['middleware' => 'auth'], function () {
    Route::get('dashboard', [UserDashboardController::class, 'index'])->name('dashboard');
    
    Route::get('logout', [\App\Http\Controllers\User\UserAuthController::class, 'logout'])->name('logout');
    Route::get('dashboard', [UserDashboardController::class, 'index'])->name('dashboard');
    Route::post('profile.create', [\App\Http\Controllers\User\UserProfileController::class, 'createProfile'])->name('profile.create');
    Route::put('update-profile-image', [\App\Http\Controllers\User\UserProfileController::class, 'updateProfileImage'])->name('update.profile.image');

    Route::get('profile', [\App\Http\Controllers\User\UserProfileController::class, 'index'])->name('userProfile');
    Route::get('blood_request', [\App\Http\Controllers\User\UserProfileController::class, 'blood_request'])->name('bloodRequest');
    Route::post('blood_request_upload', [\App\Http\Controllers\User\UserProfileController::class, 'blood_request_upload'])->name('bloodRequestUpload');
    Route::get('contact_foundation/{id}', [UserFoundationController::class, 'contactFoundation'])->name('contactFoundation');
    Route::post('contact_foundation_upload/{f_id}', [UserFoundationController::class, 'contactFoundationUpload'])->name('contactFoundationUpload');

    // User Profile
    Route::get('Birthplace/Division/dist', [\App\Http\Controllers\User\UserProfileController::class, 'DivisionByDist']);
    Route::get('Birthplace/Districts/Upzilla', [\App\Http\Controllers\User\UserProfileController::class, 'DistrictsByUpzilla']);
    Route::get('Birthplace/Upzilla/Union', [\App\Http\Controllers\User\UserProfileController::class, 'UpzillaByUnion']);
    Route::get('Birthplace/Union/Ward/', [\App\Http\Controllers\User\UserProfileController::class, 'UnionByWard']);
    Route::get('Birthplace/Ward/vallage', [\App\Http\Controllers\User\UserProfileController::class, 'WardByVallage']);
});


Route::get('{code}', function ($code) {
    if (!$data = BloodRequestMessage::query()->with(['blood_request'])->where(['code' => $code])->first()) {
        return abort(404);
    }
    return view('frontend.pages.blood_request_view', compact('data'));
});