<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\HospitalAuthController;
use App\Http\Controllers\Hospital\HospitalDashboardController;

Route::prefix('hospital')->as('hospital.')->group(function () {
    Route::get('login', [HospitalAuthController::class, 'login'])->name('login');
    Route::post('login', [HospitalAuthController::class, 'save_login'])->name('save_login');

    Route::get('register', [HospitalAuthController::class, 'register'])->name('register');
    Route::post('register', [HospitalAuthController::class, 'save_register'])->name('save_register');
    Route::get('verify-otp', [HospitalAuthController::class, 'verifyOtphospital'])->name('verify.otp');
    Route::post('verify-otp-match', [HospitalAuthController::class, 'verifyOtpMatch'])->name('verify.otp.match');

    Route::get('contact', [HospitalAuthController::class, 'contact'])->name('contact');

    Route::middleware('hospital.auth')->group(function () {
        Route::get('dashboard', [HospitalDashboardController::class, 'dashboard'])->name('dashboard');
        Route::get('contact', [HospitalDashboardController::class, 'contact'])->name('contact');
        Route::get('logout', [HospitalDashboardController::class, 'logout'])->name('logout');
    });
});