<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\FoundationAuthController;
use App\Http\Controllers\Foundation\FoundationDashboardController;
use App\Http\Controllers\Foundation\FoundationDesignationController;

Route::prefix('foundation')->as('foundation.')->group(function () {
    Route::get('login', [FoundationAuthController::class, 'login'])->name('login');
    Route::post('login', [FoundationAuthController::class, 'save_login'])->name('save_login');

    Route::get('register', [FoundationAuthController::class, 'register'])->name('register');
    Route::post('register', [FoundationAuthController::class, 'save_register'])->name('save_register');
    Route::get('verify-otp', [FoundationAuthController::class, 'verifyOtpFoundation'])->name('verify.otp');
    Route::post('verify-otp-match', [FoundationAuthController::class, 'verifyOtpMatch'])->name('verify.otp.match');

    Route::get('contact', [FoundationAuthController::class, 'contact'])->name('contact');

    Route::middleware('foundation.auth')->group(function () {
        Route::get('dashboard', [FoundationDashboardController::class, 'dashboard'])->name('dashboard');

        Route::resource('addDesignation', FoundationDesignationController::class);
        Route::post('getAllData', [FoundationDesignationController::class, 'getAllData'])->name('getAllData');
        Route::get('contact', [FoundationDashboardController::class, 'contact'])->name('contact');
        Route::get('logout', [FoundationDashboardController::class, 'logout'])->name('logout');
    });
});
