<?php

use App\Models\District;
use App\Models\Upazilla;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('v1')->group(function () {
    Route::get('districts', function () {
        $fields    = ['id', 'title'];
        $condition = [];
        if (request()->has('division_id') && request()->input('division_id')) {
            $condition['division_id'] = request()->input('division_id');
        }
        $queries = District::query()->where($condition)->select($fields)->get();
        return response()->json(['status' => 'success', 'statusCode' => 200, 'data' => $queries], 200);
    });

    Route::get('upzillas', function () {
        $fields    = ['id', 'title'];
        $condition = [];

        if (request()->has('division_id') && request()->input('division_id')) {
            $condition['division_id'] = request()->input('division_id');
        }
        if (request()->has('district_id') && request()->input('district_id')) {
            $condition['district_id'] = request()->input('district_id');
        }

        $queries = Upazilla::query()->where($condition)->select($fields)->get();
        return response()->json(['status' => 'success', 'statusCode' => 200, 'data' => $queries], 200);
    });
});
