@extends('user.layouts.app')
@section('style')
    <style>
        .progress-bar {
            width: 100%;
            background: #f0f0f0;
            border-radius: 5px;
            overflow: hidden;
            margin-bottom: 20px;
        }

        .progress-bar-fill {
            height: 20px;
            width: 0%;
            background: #4CAF50;
            text-align: center;
            line-height: 20px;
            color: #fff;
            font-weight: bold;
            transition: width 0.3s ease-in-out;
        }

        .form-step {
            display: none;
        }

        .form-step.active {
            display: block;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 14px;
        }

        .buttons {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

        button {
            padding: 10px 20px;
            font-size: 16px;
            color: #fff;
            background-color: #4CAF50;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        button[disabled] {
            background-color: #ccc;
            cursor: not-allowed;
        }

        .output {
            margin-top: 20px;
            text-align: center;
            padding: 10px;
            background: #e7f3e7;
            border: 1px solid #c8e6c9;
            border-radius: 5px;
        }
    </style>
@endsection
@section('content')
    <!-- ---------- Profile ---------- -->
    <!-- ---------- Profile ---------- -->
    <div class="profile mt-5">
        <div>
            {{-- <div class="id_profile">
                <div class="text_id_profile">
                    <div class="img_icon_profile">
                        <form action="{{ route('update.profile.image') }}" method="post" enctype="multipart/form-data"
                            id="profilePicForm">
                            @csrf
                            @method('PUT')
                            <div class="img_profile">
                                @if ($UserProfile && $UserProfile->ProfileImage)
                                    <img src="{{ asset('user/' . $UserProfile->ProfileImage) }}" alt="Profile Image"
                                        id="profileImagePreview">
                                @else
                                    <img src="{{ asset('default-image.jpg') }}" alt="Default Profile Image"
                                        id="profileImagePreview">
                                @endif
                            </div>
                            <input type="file" name="ProfileImage">
                            <button type="submit" id="submitBtn">Update</button>
                        </form>
                    </div>
                    <h3>{{ $user->name }}</h3>
                    <p>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                            class="bi bi-telephone" viewBox="0 0 16 16">
                            <path
                                d="M3.654 1.328aPlease fill out This field.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                        </svg>
                        <span>{{ $user->phone }}</span>
                    </p>
                    <p>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                            class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                            <path
                                d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                        </svg>
                        <span>{{ $user->email }}</span>
                    </p>
                    <hr>
                </div>
                <div class="content_profile">
                    <div class="item_profile">
                        <p>
                            <span>Do you want to <br> donate Blood ?</span>
                        </p>
                        <div style="display: flex; gap: 5px;">
                            <h4 class="varefy_profile" id="bloodWant">Yes</h4>
                            <h4 class="varefy_profile">No</h4>
                        </div>
                    </div>
                    <div class="item_profile">
                        <p>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                fill="currentColor" class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                                <path
                                    d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                            </svg>
                            <span>NID</span>
                        </p>
                        <h4 class="varefy_profile">Verify</h4>
                    </div>
                    <div class="item_profile">
                        <p>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                fill="currentColor" class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                                <path
                                    d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                            </svg>
                            <span>BRN</span>
                        </p>
                        <h4 class="varefy_profile">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                fill="currentColor" class="bi bi-check-lg" viewBox="0 0 16 16">
                                <path
                                    d="M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425a.247.247 0 0 1 .02-.022Z" />
                            </svg>
                        </h4>
                    </div>
                    <div class="item_profile">
                        <p>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                fill="currentColor" class="bi bi-chat-left-text-fill" viewBox="0 0 16 16">
                                <path
                                    d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4.414a1 1 0 0 0-.707.293L.854 15.146A.5.5 0 0 1 0 14.793V2zm3.5 1a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9zm0 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5z" />
                            </svg>
                            <span>Password</span>
                        </p>
                        <h4 class="varefy_profile">Edit</h4>
                    </div>
                </div>
            </div> --}}
        </div>

        <!-- adderss profile -->
        <div class="adderss_profile ">
            <!-- <h4>Profile</h4> -->
            {{-- <div class="all_profile">
                <div class="profile_content">
                    <div class="profile_item active">
                        <h4>My <br> Profile</h4>
                    </div>
                    <div class="profile_item">
                        <h4>Birthplace <br> Address</h4>
                    </div>
                    <div class="profile_item">
                        <h4>Parmament <br> Address</h4>
                    </div>
                    <div class="profile_item">
                        <h4>Current <br> Address</h4>
                    </div>
                    <div class="profile_item">
                        <h4>Check & <br> Review</h4>
                    </div>
                </div>
            </div> --}}
            <div class="data_profile">
                <form action="{{ route('profile.create') }}" method="post">
                    @csrf
                    <div class="progress-bar">
                        <div class="progress-bar-fill" id="progressBar">0%</div>
                    </div>
                    <div class="profile_items form-step active" id="step-1">
                        <!-- My Profile -->


                        <h2>My Profile</h2>
                        <div class="alert alert-danger errorField" role="alert">
                            <p style="color: red; padding-left:5px; margin:0">Please fill out This field</p>
                        </div>

                        <div class="profile_form">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="name">Name</label>
                                        <input type="text" name="Name" id="name" placeholder="Your Name"
                                            value="{{ $user->name }}" class="form-control mb-2" required>
                                        <input type="hidden" name="User_id" value="{{ $user->id }}">

                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="fatherName">Father Name</label>
                                        <input type="text" class="errorfather form-control mb-2" name="FatherName"
                                            value="{{ $UserProfile ? $UserProfile->FatherName : '' }}" id="fatherName"
                                            placeholder="Father Name">

                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="motherName">Mother Name</label>
                                        <input type="text" class="errormother form-control mb-2" name="MotherName"
                                            value="{{ $UserProfile ? $UserProfile->MotherName : '' }}" id="motherName"
                                            placeholder="Mother Name">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="gender">Gender</label>
                                        <div class="form_select">
                                            {{-- <select name="Gender" class="form-control mb-2">
                                                <option value="none">Select</option>
                                                @if ($UserProfile)
                                                    @if ($UserProfile->Gender == 'male')
                                                        <option value="male" selected>Male</option>
                                                        <option value="female">Female</option>
                                                        <option value="other">Other</option>
                                                    @elseif ($UserProfile->Gender == 'female')
                                                        <option value="male">Male</option>
                                                        <option value="female" selected>Female</option>
                                                        <option value="other">Other</option>
                                                    @elseif ($UserProfile->Gender == 'other')
                                                        <option value="male">Male</option>
                                                        <option value="female">Female</option>
                                                        <option value="other" selected>Other</option>
                                                    @endif
                                                @else
                                                    <option value="male">Male</option>
                                                    <option value="female">Female</option>
                                                    <option value="other">Other</option>
                                                @endif

                                            </select> --}}
                                            @php
                                                $genders = ['male' => 'Male', 'female' => 'Female', 'other' => 'Other'];
                                            @endphp

                                            <select name="Gender" class="form-control mb-2">
                                                <option value="none"
                                                    {{ $UserProfile && !$UserProfile->Gender ? 'selected' : '' }}>Select
                                                </option>
                                                @foreach ($genders as $value => $label)
                                                    <option value="{{ $value }}"
                                                        {{ $UserProfile && $UserProfile->Gender == $value ? 'selected' : '' }}>
                                                        {{ $label }}
                                                    </option>
                                                @endforeach
                                            </select>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="email">Email</label>
                                        <input type="email" name="Email" id="email" class="form-control erroremail"
                                            value="{{ $user->email }}"placeholder="Email">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="phone">Phone</label>
                                        <input type="text" name="AnotherPhone" id="phone"
                                            value="{{ $UserProfile && $UserProfile->AnotherPhone ? $UserProfile->AnotherPhone : '+880' }}"
                                            placeholder="Phone" class="form-control errorphone" required>
                                    </div>
                                </div>
                                <div class="col-md-4">

                                    <div class="form_group">
                                        <label for="blood">Blood Group</label>
                                        <div class="form_select">
                                            <select id="BloodGroup" class="form-control" name="BloodGroup">
                                                <option value="none">Select</option>
                                                @foreach ($BloodGroup as $name)
                                                    <option value="{{ $name->bloodGroup }}">
                                                        {{ $name->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="occupation">Profession</label>
                                        <div class="form_select">
                                            <select id="gender" class="form-control" name="Occupation">

                                                <option value="none">Select</option>
                                                @foreach ($professions as $profession)
                                                    <option value="{{ $profession->id }}">{{ $profession->title }}
                                                    </option>
                                                @endforeach
                                                {{-- @if ($UserProfile)
                                                    @if ($UserProfile->Occupation == 'male')
                                                        <option value="Acoountant" selected>Acoountant</option>
                                                        <option value="Manger">Manger</option>
                                                        <option value="Admin">Admin</option>
                                                    @elseif ($UserProfile->Occupation == 'Manger')
                                                        <option value="Acoountant">Acoountant</option>
                                                        <option value="Manger" selected>Manger</option>
                                                        <option value="Admin">Admin</option>
                                                    @elseif ($UserProfile->Occupation == 'Admin')
                                                        <option value="Acoountant">Acoountant</option>
                                                        <option value="Manger">Manger</option>
                                                        <option value="Admin" selected>Admin</option>
                                                    @endif
                                                @else
                                                    <option value="Acoountant">Acoountant</option>
                                                    <option value="Manger">Manger</option>
                                                    <option value="Admin">Admin</option>
                                                @endif --}}

                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="MaritalStatus">Marital Status:</label>
                                        <div class="form_select">
                                            <select id="gender" class="form-control" name="MaritalStatus">
                                                <option value="none"
                                                    {{ optional($UserProfile)->MaritalStatus == 'none' ? 'selected' : '' }}>
                                                    Select</option>
                                                <option value="single"
                                                    {{ optional($UserProfile)->MaritalStatus == 'single' ? 'selected' : '' }}>
                                                    Unmarried</option>
                                                <option value="married"
                                                    {{ optional($UserProfile)->MaritalStatus == 'married' ? 'selected' : '' }}>
                                                    Married</option>
                                                <option value="widowed"
                                                    {{ optional($UserProfile)->MaritalStatus == 'widowed' ? 'selected' : '' }}>
                                                    Widowed</option>
                                                <option value="divorced"
                                                    {{ optional($UserProfile)->MaritalStatus == 'divorced' ? 'selected' : '' }}>
                                                    Divorced</option>
                                                <option value="legally"
                                                    {{ optional($UserProfile)->MaritalStatus == 'legally' ? 'selected' : '' }}>
                                                    Legally Separated</option>
                                                <option value="domestic"
                                                    {{ optional($UserProfile)->MaritalStatus == 'domestic' ? 'selected' : '' }}>
                                                    Cohabiting</option>
                                            </select>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                    <div class="profile_items form-step" id="step-2">
                        <h2>Birthplace Address</h2>
                        <div class="profile_form">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Division">Division</label>
                                        <select class="BirthplaceDivisions form-control" name="BirthplaceDivision">
                                            <option value="">-Select-</option>
                                            @foreach ($Division as $name)
                                                @if ($UserProfile)
                                                    <option
                                                        {{ $name->id == $UserProfile->BirthplaceDivision ? 'selected' : '' }}
                                                        value="{{ $name->id }}">{{ $name->title }}</option>
                                                @endif
                                                <option value="{{ $name->id }}">{{ $name->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="District">District</label>
                                        <select class="BirthplaceDistricts form-control" name="BirthplaceDistrict">
                                            <option value="">-Select-</option>
                                            @foreach ($District as $item)
                                                @if ($UserProfile)
                                                    <option
                                                        {{ $item->id == $UserProfile->BirthplaceDistrict ? 'selected' : 'disabled' }}
                                                        value="{{ $item->id }}">{{ $item->title }}</option>
                                                @endif
                                                <option value="{{ $item->id }}">{{ $item->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Upzilla">Upzilla</label>
                                        <select class="BirthplaceUpzillas form-control" class="BirthplaceUpzilla">
                                            <option value="">-Select-</option>
                                            @foreach ($Upazilla as $item)
                                                @if ($UserProfile)
                                                    <option
                                                        {{ $item->id == $UserProfile->BirthplaceUpzilla ? 'selected' : 'disabled' }}
                                                        value="{{ $item->id }}">{{ $item->title }}</option>
                                                @endif
                                                <option value="{{ $item->id }}">{{ $item->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="District">Union</label>
                                        <select class="BirthplaceUnions form-control" name="BirthplaceUnion">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Ward">Ward</label>
                                        <select class="BirthplaceWards form-control" name="BirthplaceWard ">

                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Village">Village</label>
                                        <select class="BirthplaceVillages form-control" name="BirthplaceVillage">

                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile_items form-step" id="step-3">
                        <h2>Permament Address</h2>
                        <div class="profile_form">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Division">Division</label>
                                        <select class="PermanentDivisions form-control" name="PermanentDivision">
                                            <option value="">-Select-</option>
                                            @foreach ($Division as $name)
                                                <option value="{{ $name->id }}">{{ $name->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="District">District</label>
                                        <select class="PermanentDistricts form-control" name="PermanentDistrict">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Upzilla">Upzilla</label>
                                        <select class="PermanenteUpzillas form-control" name="PermanentUpzilla">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="District">Union</label>
                                        <select class="PermanentUnions form-control" name="PermanentUnion">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Ward">Ward</label>
                                        <select class="PermanentWards form-control" name="PermanentWard">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Village">Village</label>
                                        <select class="PermanentVillages form-control" name="PermanentVillage">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile_items form-step" id="step-4">
                        <!-- current Address -->
                        <h2>Current Adderss</h2>
                        <div class="profile_form">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Division">Division</label>
                                        <select class="CurrentDivisions form-control" name="CurrentDivision">
                                            <option value="">-Select-</option>
                                            @foreach ($Division as $name)
                                                <option value="{{ $name->id }}">{{ $name->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="District">District</label>
                                        <select class="CurrentDistricts form-control" name="CurrentDistrict">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Upzilla">Upzilla</label>
                                        <select class="CurrentUpzillas form-control" name="CurrentUpzilla">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="District">Union</label>
                                        <select class="CurrentUnions form-control" name="CurrentUnion">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Ward">Ward</label>
                                        <select class="CurrentWard form-control" name="CurrentWard">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form_group">
                                        <label for="Village">Village</label>
                                        <select class="CurrentVillage form-control" name="CurrentVillage">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="buttons">
                        <button id="prevBtn" type="button" onclick="changeStep(-1)" disabled>Previous</button>
                        <button type="submit" class="profile_countinue" onclick="changeStep(1); disableSubmit();" id="nextBtn">Next</button>
                    </div>
                </form>
            </div>

        </div>
    </div>
    <!-- ---------- Profile end ---------- -->


    <!-- ---------- JS end ---------- -->
@endsection

@section('script-js')
    <script>
        $("#Profile").show();
        $("#Birthplace").hide();
        $("#Parmament").hide();
        $("#Current").hide();
        $("#myFunctionOne").show();
        $("#myFunctionTwo").hide();
        $("#myFunctionThree").hide();
        $("#myFunctionFour").hide();
        $("#myFunctionFive").hide();
        $(".errorField").hide();
        $('.errorfather').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $('.errormother').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $('.erroremail').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $('.errorphone').on("keyup", function() {
            var father = $(this).val();
            if (father) {
                $('.errorField').hide();
            } else {
                $(".errorField").show();
            }
        });
        $("#myFunctionOne").click(function() {
            var father = $('.errorfather').val();
            var mother = $('.errormother').val();
            var email = $('.erroremail').val();
            var phone = $('.errorphone').val();
            if (father && mother && email && phone) {
                $("#Profile").hide();
                $("#Birthplace").show();

                $("#myFunctionOne").hide();
                $("#myFunctionTwo").show();

            } else {
                $(".errorField").show();
            }
        });
        $("#myFunctionTwo").click(function() {
            $("#Profile").hide();
            $("#Birthplace").hide();
            $("#Parmament").show();

            $("#myFunctionOne").hide();
            $("#myFunctionTwo").hide();
            $("#myFunctionThree").show();
        });

        $("#myFunctionThree").click(function() {
            $("#Profile").hide();
            $("#Birthplace").hide();
            $("#Parmament").hide();
            $("#Current").show();

            $("#myFunctionOne").hide();
            $("#myFunctionTwo").hide();
            $("#myFunctionThree").hide();
            $("#myFunctionFour").show();
        });
        $("#myFunctionFour").click(function() {
            $("#Profile").show();
            $("#Birthplace").show();
            $("#Parmament").show();
            $("#Current").show();

            $("#myFunctionOne").hide();
            $("#myFunctionTwo").hide();
            $("#myFunctionThree").hide();
            $("#myFunctionFour").hide();
            $("#myFunctionFive").show();
        });

        $("#backFunctionTwo").click(function() {
            $("#Birthplace").hide();
            $("#Profile").show();
            $("#myFunctionTwo").hide();
            $("#myFunctionOne").show();
        });

        $("#backFunctionThree").click(function() {
            $("#Parmament").hide();
            $("#Birthplace").show();
            $("#myFunctionThree").hide();
            $("#myFunctionTwo").show();
        });

        $("#backFunctionFour").click(function() {
            $("#Current").hide();
            $("#Parmament").show();
            $("#myFunctionFour").hide();
            $("#myFunctionThree").show();
        });
        $(document).on('change', '.BirthplaceDivisions', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Division/dist') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.BirthplaceDistricts').empty();
                    $('.BirthplaceDistricts').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.BirthplaceDistricts', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Districts/Upzilla') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="" selected>-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.BirthplaceUpzillas').empty();
                    $('.BirthplaceUpzillas').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.BirthplaceUpzillas', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Upzilla/Union') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.BirthplaceUnions').empty();
                    $('.BirthplaceUnions').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.BirthplaceUnions', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Union/Ward') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.BirthplaceWards').empty();
                    $('.BirthplaceWards').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.BirthplaceWards', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Ward/vallage') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.BirthplaceVillages').empty();
                    $('.BirthplaceVillages').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.PermanentDivisions', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Division/dist') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.PermanentDistricts').empty();
                    $('.PermanentDistricts').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.PermanentDistricts', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Districts/Upzilla') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.PermanenteUpzillas').empty();
                    $('.PermanenteUpzillas').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.PermanenteUpzillas', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Upzilla/Union') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.PermanentUnions').empty();
                    $('.PermanentUnions').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.PermanentUnions', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Union/Ward') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.PermanentWards').empty();
                    $('.PermanentWards').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.PermanentWards', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Ward/vallage') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.PermanentVillages').empty();
                    $('.PermanentVillages').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.CurrentDivisions', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Division/dist') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.CurrentDistricts').empty();
                    $('.CurrentDistricts').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.CurrentDistricts', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Districts/Upzilla') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.CurrentUpzillas').empty();
                    $('.CurrentUpzillas').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.CurrentUpzillas', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Upzilla/Union') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.CurrentUnions').empty();
                    $('.CurrentUnions').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });

        });
        $(document).on('change', '.CurrentUnions', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Union/Ward') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.CurrentWard').empty();
                    $('.CurrentWard').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        });
        $(document).on('change', '.CurrentWard', function() {
            var id = $(this).val();
            $_token = "{{ csrf_token() }}";
            $.ajax({
                headers: {
                    'X-CSRF-Token': $('meta[name=_token]').attr('content')
                },
                url: "{{ url('/Birthplace/Ward/vallage') }}",
                type: 'GET',
                cache: false,
                data: {
                    '_token': $_token,
                    'id': id,
                },
                datatype: 'application/json',
                beforeSend: function() {},
                success: function(data) {
                    var txt = '<option value="">-Select-</option>';
                    data.forEach(element => {
                        txt += '<option value="' + element.id + '">' + element
                            .title + '</option>';
                    });
                    $('.CurrentVillage').empty();
                    $('.CurrentVillage').append(txt);
                },
                error: function(error) {
                    console.log(error);
                }
            });

        });
    </script>
    <script>
        // let currentStep = 1;
        // const totalSteps = 4;
        // function changeStep(direction) {
        //     document.getElementById(`step-${currentStep}`).classList.remove('active');
        //     currentStep += direction;
        //     document.getElementById(`step-${currentStep}`).classList.add('active');
        //     updateProgressBar();
        //     document.getElementById('prevBtn').disabled = currentStep === 1;
        //     document.getElementById('nextBtn').disabled = currentStep === totalSteps;
        //     if (currentStep === totalSteps) {
        //         document.getElementById('nextBtn').innerText = 'Submit';
        //     } else {
        //         document.getElementById('nextBtn').innerText = 'Next';
        //     }
        //     if (currentStep > totalSteps) {
        //         showSummary();
        //     }
        // }

        // function updateProgressBar() {
        //     const progress = Math.round((currentStep / totalSteps) * 100);
        //     const progressBar = document.getElementById('progressBar');
        //     progressBar.style.width = `${progress}%`;
        //     progressBar.innerText = `${progress}%`;
        // }
        let currentStep = 1;
const totalSteps = 4;

function changeStep(direction) {
    document.getElementById(`step-${currentStep}`).classList.remove('active');
    currentStep += direction;
    document.getElementById(`step-${currentStep}`).classList.add('active');
    updateProgressBar();

    // Enable or disable the 'Previous' button
    document.getElementById('prevBtn').disabled = currentStep === 1;

    // Enable or disable the 'Next' button
    const nextBtn = document.getElementById('nextBtn');
    if (currentStep === totalSteps) {
        nextBtn.innerText = 'Submit';
        nextBtn.type = 'submit'; // Change type to 'submit' for form submission
        nextBtn.disabled = false; // Make sure it's not disabled on the final step
    } else {
        nextBtn.innerText = 'Next';
        nextBtn.type = 'button'; // Keep it as a button for navigation
        nextBtn.disabled = false; // Enable the button when it's not the last step
    }
}

// Disable submit button after it's clicked
function disableSubmit() {
    const nextBtn = document.getElementById('nextBtn');
    nextBtn.disabled = true; // Disable submit button after it is clicked
    nextBtn.innerText = 'Submitting...'; // Change text to indicate submission
}

function updateProgressBar() {
    const progress = Math.round((currentStep / totalSteps) * 100);
    const progressBar = document.getElementById('progressBar');
    progressBar.style.width = `${progress}%`;
    progressBar.innerText = `${progress}%`;
}

    </script>
@endsection
{{-- @section('script-js')
<script>
    // Show or hide sections
    function toggleSection(showId, buttonId) {
        $(".section").hide(); // Add a common class to all sections (e.g., Profile, Birthplace, etc.)
        $("#" + showId).show();

        $(".navigation-button").hide(); // Add a common class to navigation buttons
        $("#" + buttonId).show();
    }

    // Initialize sections and buttons
    $(document).ready(function() {
        toggleSection('Profile', 'myFunctionOne');
        $(".errorField").hide();

        // Input validation with a single function
        $(".validateField").on("keyup", function() {
            let isValid = true;
            $(".validateField").each(function() {
                if (!$(this).val().trim()) {
                    isValid = false;
                }
            });
            $(".errorField").toggle(!isValid);
        });
    });

    // Next button click handlers
    $("#myFunctionOne").click(function() {
        if ($(".errorField:visible").length === 0) {
            toggleSection('Birthplace', 'myFunctionTwo');
        }
    });
    $("#myFunctionTwo").click(function() {
        toggleSection('Parmament', 'myFunctionThree');
    });
    $("#myFunctionThree").click(function() {
        toggleSection('Current', 'myFunctionFour');
    });
    $("#myFunctionFour").click(function() {
        toggleSection('Summary', 'myFunctionFive');
    });

    // Back button click handlers
    $("#backFunctionTwo").click(function() {
        toggleSection('Profile', 'myFunctionOne');
    });
    $("#backFunctionThree").click(function() {
        toggleSection('Birthplace', 'myFunctionTwo');
    });
    $("#backFunctionFour").click(function() {
        toggleSection('Parmament', 'myFunctionThree');
    });

    // Reusable AJAX function
    function fetchDropdownData(url, id, targetClass) {
        const csrfToken = "{{ csrf_token() }}";
        $.ajax({
            url: url,
            type: 'GET',
            data: {
                '_token': csrfToken,
                'id': id,
            },
            beforeSend: function() {
                // Optional: Add loader
            },
            success: function(data) {
                const options = data.map(item => `<option value="${item.id}">${item.title}</option>`).join('');
                $(targetClass).html(`<option value="">-Select-</option>${options}`);
            },
            error: function(error) {
                console.error("Error fetching data:", error);
            }
        });
    }

    // Cascading dropdowns
    $(document).on('change', '.BirthplaceDivisions, .PermanentDivisions', function() {
        const id = $(this).val();
        const target = $(this).hasClass('BirthplaceDivisions') ? '.BirthplaceDistricts' : '.PermanentDistricts';
        fetchDropdownData("{{ url('/Birthplace/Division/dist') }}", id, target);
    });

    $(document).on('change', '.BirthplaceDistricts, .PermanentDistricts', function() {
        const id = $(this).val();
        const target = $(this).hasClass('BirthplaceDistricts') ? '.BirthplaceUpzillas' : '.PermanentUpzillas';
        fetchDropdownData("{{ url('/Birthplace/Districts/Upzilla') }}", id, target);
    });

    $(document).on('change', '.BirthplaceUpzillas, .PermanentUpzillas', function() {
        const id = $(this).val();
        const target = $(this).hasClass('BirthplaceUpzillas') ? '.BirthplaceUnions' : '.PermanentUnions';
        fetchDropdownData("{{ url('/Birthplace/Upzilla/Union') }}", id, target);
    });

    $(document).on('change', '.BirthplaceUnions, .PermanentUnions', function() {
        const id = $(this).val();
        const target = $(this).hasClass('BirthplaceUnions') ? '.BirthplaceWards' : '.PermanentWards';
        fetchDropdownData("{{ url('/Birthplace/Union/Ward') }}", id, target);
    });

    $(document).on('change', '.BirthplaceWards, .PermanentWards', function() {
        const id = $(this).val();
        const target = $(this).hasClass('BirthplaceWards') ? '.BirthplaceVillages' : '.PermanentVillages';
        fetchDropdownData("{{ url('/Birthplace/Ward/village') }}", id, target);
    });
</script>
@endsection --}}
