<nav id="sidebar" aria-label="Main Navigation">
    <!-- Side Header -->
    <div class="bg-header-dark">
        <div class="content-header bg-white-5">
            <!-- Logo -->
            <a class="fw-semibold text-white tracking-wide" href="{{ route('dashboard') }}">
                <span class="smini-visible">
                    User Dashboard
                </span>
                <span class="smini-hidden">
                    <span class="opacity-100"> User Dashboard</span>
                </span>
            </a>
            <!-- END Logo -->

            <!-- Options -->
            <div>
                <!-- Toggle Sidebar Style -->
                <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                <!-- Class Toggle, functionality initialized in Helpers.dmToggleClass() -->
                <button type="button" class="btn btn-sm btn-alt-secondary" data-toggle="class-toggle"
                    data-target="#sidebar-style-toggler" data-class="fa-toggle-off fa-toggle-on"
                    onclick="Dashmix.layout('sidebar_style_toggle');Dashmix.layout('header_style_toggle');">
                    <i class="fa fa-toggle-off" id="sidebar-style-toggler"></i>
                </button>
                <!-- END Toggle Sidebar Style -->

                <!-- Dark Mode -->
                <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                <button type="button" class="btn btn-sm btn-alt-secondary" data-toggle="class-toggle"
                    data-target="#dark-mode-toggler" data-class="far fa" onclick="Dashmix.layout('dark_mode_toggle');">
                    <i class="far fa-moon" id="dark-mode-toggler"></i>
                </button>
                <!-- END Dark Mode -->

                <!-- Close Sidebar, Visible only on mobile screens -->
                <!-- Layout API, functionality initialized in Template._uiApiLayout() -->
                <button type="button" class="btn btn-sm btn-alt-secondary d-lg-none" data-toggle="layout"
                    data-action="sidebar_close">
                    <i class="fa fa-times-circle"></i>
                </button>
                <!-- END Close Sidebar -->
            </div>
            <!-- END Options -->
        </div>
    </div>
    <!-- END Side Header -->

    <!-- Sidebar Scrolling -->
    <div class="js-sidebar-scroll" id="js-sidebar">
        <!-- Side Navigation -->
        @php
            $url_array = explode('/', Request::path());
        @endphp
        <div class="content-side">
            @auth
                <a href="{{ route('userProfile') }}"
                    class="user-profile-item d-flex flex-column justify-content-center align-items-center gap-2 mb-4">
                    @if (auth()->user()->ProfileImage)
                        <!-- Check if ProfileImage exists -->
                        <div class="user-profile w-25">
                            <img class="w-100 rounded" src="{{ asset('storage/' . auth()->user()->ProfileImage) }}"
                                alt="Profile Picture">
                        </div>
                    @else
                        <div class="user-profile w-25">
                            <img class="w-100 rounded" src="{{ asset('frontend/assets/Image/user.png') }}"
                                alt="Default Profile Picture">
                        </div>
                    @endif
                    <div class="user-name">
                        {{ auth()->user()->name }}
                    </div>
                </a>
            @endauth

            @guest
                <div class="user-name">
                    Guest User
                </div>
            @endguest


            <ul class="nav-main">
                <li class="nav-main-item">
                    <a class="nav-main-link {{ Route::currentRouteName() == 'dashboard' ? 'active' : '' }}"
                        href="{{ route('dashboard') }}">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name">{{ trans('Dashboard') }}</span>
                    </a>
                </li>
                <li class="nav-main-item">
                    <a class="nav-main-link" href="">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name">Account Number</span>
                    </a>
                </li>
                {{-- <li class="nav-main-item">
                    <a class="nav-main-link" href="">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name"> </span>
                    </a>
                </li> --}}
                <li class="nav-main-item">
                    <a class="nav-main-link nav-main-link-submenu" data-toggle="submenu" aria-haspopup="true"
                        aria-expanded="false" href="#">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name">{{ trans('Documents') }}</span>
                    </a>
                    <ul class="nav-main-submenu">
                        <li class="nav-main-item">
                            <a class="nav-main-link " href="">
                                <i class="nav-main-link-icon fa fa-border-all"></i>
                                <span class="nav-main-link-name">{{ trans('NID Cards') }}</span>
                            </a>
                            <a class="nav-main-link " href="">
                                <i class="nav-main-link-icon fa fa-border-all"></i>
                                <span class="nav-main-link-name">{{ trans('Passports') }}</span>
                            </a>
                            <a class="nav-main-link " href="">
                                <i class="nav-main-link-icon fa fa-border-all"></i>
                                <span class="nav-main-link-name">{{ trans('Certificates & ID Cards') }}</span>
                            </a>
                        </li>
                    </ul>


                </li>
                {{-- <li class="nav-main-item">
                    <a class="nav-main-link" href="{{ route('contact') }}">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name">{{ trans('Contact From User') }}</span>
                    </a>
                </li>
                <li class="nav-main-item">
                    <a class="nav-main-link" href="{{ route('contact') }}">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name">{{ trans('Contact From User') }}</span>
                    </a>
                </li>
                <li class="nav-main-item">
                    <a class="nav-main-link" href="{{ route('contact') }}">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name">{{ trans('Contact From User') }}</span>
                    </a>
                </li> --}}


                <li class="nav-main-heading">Frontend Section</li>


                <li class="nav-main-item">
                    <a class="nav-main-link nav-main-link-submenu" data-toggle="submenu" aria-haspopup="true"
                        aria-expanded="false" href="#">
                        <i class="nav-main-link-icon fa fa-border-all"></i>
                        <span class="nav-main-link-name">{{ trans('Home Page') }}</span>
                    </a>
                    <ul class="nav-main-submenu">
                        <li class="nav-main-item">
                            <a class="nav-main-link " href="">
                                <i class="nav-main-link-icon fa fa-border-all"></i>
                                <span class="nav-main-link-name">{{ trans('Banner') }}</span>
                            </a>
                        </li>
                    </ul>


                </li>
            </ul>
        </div>
        <!-- END Side Navigation -->
    </div>
    <!-- END Sidebar Scrolling -->
</nav>
