<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">

    <title>OTP Verification</title>

    <!-- Meta Information -->
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="robots" content="">

    <!-- Open Graph Meta -->
    <meta property="og:title" content="">
    <meta property="og:site_name" content="">
    <meta property="og:description" content="">
    <meta property="og:type" content="">
    <meta property="og:url" content="">
    <meta property="og:image" content="">

    <!-- Icons -->
    <link rel="shortcut icon" href="{{ get_system_favicon() }}">
    <link rel="icon" type="image/png" sizes="192x192" href="{{ get_system_favicon() }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ get_system_favicon() }}">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap">
    <link rel="stylesheet" id="css-main" href="{{ asset('admin/assets/css/admin.min.css') }}">
</head>

<body>
    <div id="page-container">
        <main id="main-container">
            <div class="row g-0 justify-content-center bg-body-dark">
                <div class="hero-static col-sm-10 col-md-8 col-xl-6 d-flex align-items-center p-2 px-sm-0">
                    <div class="block block-rounded block-transparent block-fx-pop w-100 mb-0 overflow-hidden bg-image"
                        style="background-image: url({{ get_system_logo() }});">
                        <div class="row g-0">
                            <!-- Left Section -->
                            <div class="col-md-6 order-md-1 bg-body-extra-light">
                                <div class="block-content block-content-full px-lg-5 py-md-5 py-lg-6">
                                    <div class="mb-2 text-center">
                                        <a class="link-fx fw-bold fs-1" href="/">
                                            <span class="text-dark">{{ get_system_title() }}</span>
                                        </a>
                                        <p class="text-uppercase fw-bold fs-sm text-muted">OTP Verification</p>
                                        <span id="demo"></span>
                                        <span> after which you can request a new one.</span>
                                    </div>

                                    <!-- OTP Verification Form -->
                                    <form class="js-validation-signin" action="{{ route('hospital.verify.otp.match') }}"
                                        method="POST">
                                        @csrf
                                        <div class="mb-4">
                                            <input type="text" class="form-control form-control-alt"
                                                id="login-username" name="otp" placeholder="Enter OTP">
                                        </div>
                                        <input type="hidden" name="hospital_id" value="{{ $hospital->id }}">
                                        <div class="mb-4">
                                            <button type="submit" class="btn w-100 btn-hero btn-primary">
                                                <i class="fa fa-fw fa-sign-in-alt opacity-50 me-1"></i>Verify
                                            </button>
                                        </div>
                                    </form>
                                    <form action="{{ route('resend.otp') }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="hospital_id" value="{{ $hospital->id }}">
                                        <button type="submit" class="btn btn-link">Resend OTP</button>
                                    </form>
                                </div>
                            </div>

                            <!-- Right Section with Logo and Description -->
                            <div class="col-md-6 order-md-0 bg-primary-dark-op d-flex align-items-center">
                                <div class="block-content block-content-full px-lg-5 py-md-5 py-lg-6">
                                    <div class="d-flex">
                                        <a class="flex-shrink-0 img-link me-3" href="javascript:void(0)">
                                            <img class="img-avatar img-avatar-thumb" src="{{ get_system_logo() }}"
                                                alt="System Logo">
                                        </a>
                                        <div class="flex-grow-1">
                                            <p class="text-white fw-semibold mb-1">
                                                {{ get_system_description() }}
                                            </p>
                                            <a class="text-white-75 fw-semibold" href="javascript:void(0)"></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Scripts -->
    <script src="{{ asset('admin/assets/js/admin.core.min.js') }}"></script>
    <script src="{{ asset('admin/assets/js/admin.app.min.js') }}"></script>
    <script src="{{ asset('admin/assets/js/bootstrap-notify.min.js') }}"></script>
    <script>
            // Set the date we're counting down to
           // Set the date we're counting down to
// Set the duration for the countdown (5 minutes in milliseconds)
var otpExpiryTime = 1 * 60 * 1000; // 5 minutes
var countDownDate = new Date().getTime() + otpExpiryTime;

// Update the countdown every 1 second
var x = setInterval(function() {

    // Get the current date and time
    var now = new Date().getTime();

    // Find the distance between now and the countdown date
    var distance = countDownDate - now;

    // Time calculations for minutes and seconds
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);

    // Display the result in the element with id="demo"
    document.getElementById("demo").innerHTML = minutes + "m " + seconds + "s ";

    // If the countdown is finished, write some text
    if (distance < 0) {
        clearInterval(x);
        document.getElementById("demo").innerHTML = "EXPIRED";
        // Optionally disable the OTP input or redirect
    }
}, 1000);

    </script>
    <!-- Error Notification -->
    @if (session()->has('error'))
        <script>
            Dashmix.helpers('jq-notify', {
                type: 'danger',
                icon: 'fa fa-times me-1',
                message: @json(session()->get('error')) + ' !'
            });
        </script>
    @endif

</body>

</html>
