@extends('frontend.layouts.app')
@section('content')
    <section class="login-wrapper">
        <div class="container mx-auto mb-5">
            <div class="back p-4 formWidth" style="border-radius: 20px;">
                <img src="{{ asset('frontend/assets/Image/logo.png') }}" style="width: 100px;" class="mx-auto d-block"
                    alt="">
                <h2 class="loign-title">User Login</h2>
                <form action="{{ route('store_login') }}" method="post">
                    @csrf
                    <label for="contactType">Account Login Method: *</label>
                    <!-- radio button -->
                    <div class="d-flex mb-2 gap-3">
                        <div class="form-check mx-2">
                            <input class="form-check-input border-black" type="radio" name="contactType" id="mobileRadio"
                                value="mobile" checked>
                            <label class="form-check-label" for="mobileRadio">Phone</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input border-black" type="radio" name="contactType" id="emailRadio"
                                value="email">
                            <label class="form-check-label" for="emailRadio">Email</label>
                        </div>
                    </div>

                    <!-- email or phone -->
                    <div class="form-group mb-2">
                        <label for="contactInformation">Contact Information: *</label>
                        <div id="mobileInput">
                            <input type="text" class="form-control" id="mobile" name="phone"
                                placeholder="Your mobile number">
                        </div>
                        <div id="emailInput" style="display:none;">
                            <input type="email" class="form-control" id="email" name="email"
                                placeholder="Your email">
                        </div>
                    </div>
                    <div class="form-group mb-2">
                        <label for="password">Password*</label>
                        <div class="input-group">
                            <input type="password" class="form-control" name="password" id="password" placeholder="Password" required>
                            <button type="button"  class="eye-icon-btn"  id="togglePassword">
                                <img id="icon-password" src="{{ asset('frontend/assets/Image/show-eye.png') }}"
                                    alt="Toggle Password Visibility">
                            </button>

                        </div>
                    </div>

                    <div class="form-group mb-2">
                        <label for="confirm_password">Confirm Password*</label>
                        <div class="input-group">
                            <input type="password" class="form-control" id="confirm_password" name="confirm_password"
                                placeholder="Confirm password" required>
                            <button type="button" class="eye-icon-btn" id="toggleConfirmPassword">
                                <img id="icon-confirm-password" src="{{ asset('frontend/assets/Image/show-eye.png') }}"
                                    alt="Toggle Confirm Password Visibility">
                            </button>
                        </div>
                    </div>

                    <div class="mb-3 mx-auto">
                        <div class="d-grid gap-2 mb-3">
                            <button type="submit" class="btn login-btn mt-2">Login</button>
                        </div>

                        <span class="center-div d-flex">
                            <p class="mx-2">Don't have an account?</p> <a href="{{ route('register') }}">Register</a>
                        </span>
                        <hr>
                        <div class="no_login">
                            <p><a href="{{ route('foundation.save_register') }}"><span>Foundation Register</span></a></p>

                            {{-- =======  Hosital Register and login function not working ========== --}}
                            <p><a href="javascript;"><span>Hospital Regiseter</span></a></p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection

@section('script-js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Selecting the input fields and radio buttons by ID
            const mobileInput = document.getElementById('mobileInput');
            const emailInput = document.getElementById('emailInput');
            const mobileRadio = document.getElementById('mobileRadio');
            const emailRadio = document.getElementById('emailRadio');

            // Function to show or hide input fields based on selected radio button
            function toggleInputFields() {
                if (mobileRadio.checked) {
                    mobileInput.style.display = 'block';
                    emailInput.style.display = 'none';
                } else if (emailRadio.checked) {
                    emailInput.style.display = 'block';
                    mobileInput.style.display = 'none';
                }
            }

            // Attach change event listeners to the radio buttons
            mobileRadio.addEventListener('change', toggleInputFields);
            emailRadio.addEventListener('change', toggleInputFields);

            // Call toggle function on page load to set initial visibility
            toggleInputFields();
        });


        const passwordInput = document.getElementById('password');
        const confirmPasswordInput = document.getElementById('confirm_password');
        const togglePassword = document.getElementById('togglePassword');
        const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
        const eyeIconSrc = "{{ asset('frontend/assets/Image/show-eye.png') }}";
        const eyeOffIconSrc = "{{ asset('frontend/assets/Image/close-eye.png') }}";

        // Toggle visibility for the password field
        togglePassword.addEventListener('click', () => {
            const icon = document.getElementById('icon-password');
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.src = eyeOffIconSrc; // Change icon to "hide"
            } else {
                passwordInput.type = 'password';
                icon.src = eyeIconSrc; // Change icon to "show"
            }
        });

        // Toggle visibility for the confirm password field
        toggleConfirmPassword.addEventListener('click', () => {
            const icon = document.getElementById('icon-confirm-password');
            if (confirmPasswordInput.type === 'password') {
                confirmPasswordInput.type = 'text';
                icon.src = eyeOffIconSrc; // Change icon to "hide"
            } else {
                confirmPasswordInput.type = 'password';
                icon.src = eyeIconSrc; // Change icon to "show"
            }
        });
    </script>
@endsection
