@extends('foundation.layouts.app')

@section('title')
    Designation User
@endsection

@section('breadcrumb')
    <h1 class="flex-grow-1 fs-3 fw-bold my-2 my-sm-3"> Designation User</h1>
    <nav class="flex-shrink-0 my-2 my-sm-0 ms-sm-3" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">Foundation</li>
            <li class="breadcrumb-item active" aria-current="page"> Designation User</li>
        </ol>
    </nav>
@endsection

@section('content')
    <div class="block-content block-content-full">
        <table id="example" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Account ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($foundationDesignations as $foundationDesignation)
                    <tr @if (isset($selectedFoundationDesignation) && $selectedFoundationDesignation->id === $foundationDesignation->id) style="background-color: #f0f0f0;" @endif>
                        <td>{{ $foundationDesignation->account_id }}</td>
                        <td>{{ $foundationDesignation->name }}</td>
                        <td>{{ $foundationDesignation->email }}</td>
                        <td>{{ $foundationDesignation->mobile }}</td>
                        <td>
                            <a class="btn btn-warning"
                                href="{{ route('foundation.addDesignation.edit', $foundationDesignation->id) }}">Edit</a>
                            <form method="post"
                                action="{{ route('foundation.addDesignation.destroy', $foundationDesignation->id) }}"
                                style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>
    </div>
@endsection


@push('js')
@endpush
