@extends('foundation.layouts.app')

@section('title')
    Add Designation
@endsection

@section('breadcrumb')
    <h1 class="flex-grow-1 fs-3 fw-bold my-2 my-sm-3">Add Designation</h1>
    <nav class="flex-shrink-0 my-2 my-sm-0 ms-sm-3" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">Foundation</li>
            <li class="breadcrumb-item active" aria-current="page">Add Designation</li>
        </ol>
    </nav>
@endsection

@section('content')
    <form action="{{ route('foundation.addDesignation.store') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Name:</label>
                    <input type="text" class="form-control" name="name" placeholder="Write a name" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Email:</label>
                    <input type="email" class="form-control" name="email" placeholder="Write your email" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Phone:</label>
                    <input type="tel" class="form-control" name="mobile" placeholder="Write your phone number">
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Designation:</label>
                    <select class="form-control" name="designation" required>
                        <option selected disabled>Select...</option>
                        <option value="member">Member</option>
                        <option value="chairman">Chairman</option>
                        <option value="staff">Staff</option>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Image:</label>
                    <input class="form-control" type="file" name="image" id="">
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Blood group:</label>
                    <select class="form-control" name="blood_group" required>
                        <option selected disabled>Select...</option>
                        @foreach ($bloodGroups as $bloodGroup)
                            <option value="{{ $bloodGroup->id }}">{{ $bloodGroup->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Gender:</label>
                    <select class="form-control" name="gender" required>
                        <option selected disabled>Select...</option>
                        <option value="male">Male</option>
                        <option value="female">Female</option>
                        <option value="other">Other</option>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Division:</label>
                    <select class="form-control" name="division_id" required>
                        <option selected disabled>Select...</option>
                        @foreach ($divisions as $division)
                            <option value="{{ $division->id }}">{{ $division->title }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <!-- District -->
            <div class="col-md-4">
                <div class="mb-3">
                    <label>District:</label>
                    <select class="form-control" name="district_id" required disabled>
                        <option selected disabled>Select...</option>
                    </select>
                </div>
            </div>

            <!-- Upazilla/Purashova -->
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Upazilla/Purashova:</label>
                    <select class="form-control" name="upazilla_id" required disabled>
                        <option selected disabled>Select...</option>
                    </select>
                </div>
            </div>

            <!-- Union -->
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Union:</label>
                    <select class="form-control" name="union_id" required disabled>
                        <option selected disabled>Select...</option>
                    </select>
                </div>
            </div>

            <!-- Ward -->
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Ward:</label>
                    <select class="form-control" name="ward_id" required disabled>
                        <option selected disabled>Select...</option>
                    </select>
                </div>
            </div>

            <!-- Village -->
            <div class="col-md-4">
                <div class="mb-3">
                    <label>Village:</label>
                    <select class="form-control" name="village_id" required disabled>
                        <option selected disabled>Select...</option>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label>NID Number:</label>
                    <input class="form-control" type="number" name="nid_no" id="">
                </div>
            </div>
            <div class="col-md-4">
                <div>
                    <label>Password:</label>
                    <input type="text" class="form-control" name="password" placeholder="Write your password" required>
                </div>
            </div>
            <div class="col-md-4">
                <div>
                    <label for="status">Status:</label>
                    <div class="d-flex align-items-center gap-3">
                        <input type="checkbox" name="status" id="status" value="1">
                        <label for="status">Active</label>
                    </div>
                </div>

            </div>
        </div>







        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </form>
@endsection

@push('js')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            // Handle Division Change
            $('select[name="division_id"]').change(function() {
                let divisionId = $(this).val();
                fetchOptions('division_id', divisionId, 'district_id');
            });

            // Handle District Change
            $('select[name="district_id"]').change(function() {
                let districtId = $(this).val();
                fetchOptions('district_id', districtId, 'upazilla_id');
            });

            // Handle Upazilla Change
            $('select[name="upazilla_id"]').change(function() {
                let upazillaId = $(this).val();
                fetchOptions('upazilla_id', upazillaId, 'union_id');
            });

            // Handle Union Change
            $('select[name="union_id"]').change(function() {
                let unionId = $(this).val();
                fetchOptions('union_id', unionId, 'ward_id');
            });

            // Handle Ward Change
            $('select[name="ward_id"]').change(function() {
                let wardId = $(this).val();
                fetchOptions('ward_id', wardId, 'village_id');
            });

            // Fetch and Populate Dropdown Options
            function fetchOptions(parentKey, parentId, childKey) {
                if (parentId) {
                    $.ajax({
                        url: '{{ route('foundation.getAllData') }}',
                        method: 'POST',
                        data: {
                            [parentKey]: parentId,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            let childOptions = `<option selected disabled>Select...</option>`;
                            let items = response[childKey.replace('_id', 's')]; // Pluralize key
                            items.forEach(item => {
                                childOptions +=
                                    `<option value="${item.id}">${item.title}</option>`;
                            });
                            $(`select[name="${childKey}"]`).html(childOptions).prop('disabled', false);
                        },
                        error: function() {
                            alert('Error fetching data!');
                        }
                    });
                } else {
                    $(`select[name="${childKey}"]`).html('<option selected disabled>Select...</option>').prop(
                        'disabled', true);
                }

                // Reset all dependent dropdowns
                let resetKeys = ['district_id', 'upazilla_id', 'union_id', 'ward_id', 'village_id'];
                let startReset = false;
                resetKeys.forEach(key => {
                    if (startReset || key === childKey) {
                        $(`select[name="${key}"]`).html('<option selected disabled>Select...</option>')
                            .prop('disabled', true);
                        startReset = true;
                    }
                });
            }
        });
    </script>
@endpush
