<div class="modal-dialog modal-lg modal-dialog-popout" role="document">
    <div class="modal-content">
        <div class="block block-rounded block-themed block-transparent mb-0">
            <div class="block-header bg-gd-default">
                <h3 class="block-title">@lang('upazila.create_title')</h3>
                <div class="block-options">
                    <button type="button" class="btn-block-option" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fa fa-fw fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="block-content">
                <!-- Form Grid with Labels -->
                <form method="POST" class="submit-form" action="{{ route('admin.upazillas.store') }}">
                    @csrf
                    <div class="d-flex">
                    </div>

                    <!-- Radio Buttons for Union and Pourashava Selection -->
                    {{-- <div class="row mb-3">
                        <div class="col-6">
                            <div class="form-group">
                                <input type="radio" name="type" id="union" value="union" checked>
                                <label for="union">@lang('upazila.create_union')</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <input type="radio" name="type" id="pourashava" value="pourashava">
                                <label for="pourashava">@lang('upazila.create_pourashava')</label>
                            </div>
                        </div>
                    </div> --}}

                    <!-- Comma-separated input area -->
                    <textarea id="inputTextArea" placeholder="Input text with comma-separated values"
                        class="inputTextArea form-control mb-3"></textarea>

                    <!-- Output Fields for English and Bangla -->
                    <div class="row">
                        <div class="col-6" id="outputFields"></div>
                        <div class="col-6" id="outputFieldsBn"></div>
                    </div>

                    <input type="hidden" name="district_id" value="{{ request()->get('district_id') }}" />

                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-sm btn-outline-primary mb-3">
                        @lang('upazila.save')
                    </button>
                </form>
                <!-- END Form Grid with Labels -->
            </div>
            <div class="block-content block-content-full text-end bg-gray-lighter">
                <button type="button" class="btn btn-sm btn-danger" data-bs-dismiss="modal">@lang('common.close')</button>
            </div>
        </div>
    </div>
</div>

@section('script-js')
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const inputTextArea = document.getElementById('inputTextArea');
            const outputFields = document.getElementById('outputFields');
            const outputFieldsBn = document.getElementById('outputFieldsBn');
            const unionRadio = document.getElementById('union');
            const pourashavaRadio = document.getElementById('pourashava');

            // Function to clear previous input fields
            const clearFields = () => {
                outputFields.innerHTML = '';
                outputFieldsBn.innerHTML = '';
            };

            // Function to generate dynamic input fields
            const generateFields = (type, textList) => {
                textList.forEach((text, index) => {
                    // English Input Field
                    const inputFieldEn = document.createElement('input');
                    inputFieldEn.type = 'text';
                    inputFieldEn.className = 'form-control mb-2';
                    inputFieldEn.name = `${type}_names[${index}][en]`;
                    inputFieldEn.placeholder = `Enter ${type} name in English`;
                    inputFieldEn.value = text.trim();

                    // Bangla Input Field
                    const inputFieldBn = document.createElement('input');
                    inputFieldBn.type = 'text';
                    inputFieldBn.className = 'form-control mb-2';
                    inputFieldBn.name = `${type}_names[${index}][bn]`;
                    inputFieldBn.placeholder = `Enter ${type} name in Bangla`;

                    outputFields.appendChild(inputFieldEn);
                    outputFieldsBn.appendChild(inputFieldBn);
                });
            };

            // Listen to input change and generate fields
            inputTextArea.addEventListener('input', () => {
                const textValue = inputTextArea.value;
                const textList = textValue.split(',');

                clearFields();

                const type = unionRadio.checked ? 'union' : 'pourashava';
                generateFields(type, textList);
            });

            // Update field labels based on radio button selection
            [unionRadio, pourashavaRadio].forEach(radio => {
                radio.addEventListener('change', () => {
                    const textValue = inputTextArea.value;
                    const textList = textValue.split(',');

                    clearFields();

                    const type = radio.id;
                    generateFields(type, textList);
                });
            });
        });
    </script>
@endsection
