@extends('admin.layouts.app')

@section('title')
    @lang('hospital.index_title')
@endsection

@section('breadcrumb')
    <h1 class="flex-grow-1 fs-3 fw-bold my-2 my-sm-3">@lang('hospital.index_title')</h1>
    <nav class="flex-shrink-0 my-2 my-sm-0 ms-sm-3" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">@lang('common.admin')</li>
            <li class="breadcrumb-item">@lang('common.dashboard')</li>
            <li class="breadcrumb-item active" aria-current="page">@lang('hospital.index_title')</li>
        </ol>
    </nav>
@endsection

@section('content')
    <!-- Top Products and Latest Orders -->
    <div class="row">
        <div class="col-12">
            <!-- Top Products -->
            <div class="block block-rounded">
                <div class="block-header block-header-default">
                    <h3 class="block-title">@lang('hospital.list_of_hospital')</h3>
                    <div class="block-options">
                        {{-- <button type="button" class="btn btn-sm btn-primary show-modal"
                            data-url="{{ route('admin.hospitals.create') }}">
                            <i class="fa fa-plus"></i> @lang('common.create_new')
                        </button> --}}
                        <a href="{{ route('admin.hospitals.create') }}"> <i class="fa fa-plus"></i> @lang('common.create_new')</a>
                    </div>
                </div>
            </div>
            <!-- END Top Products -->

            <div id="data-view">
                <x-card-skeleton></x-card-skeleton>
            </div>



        </div>

    </div>
    <!-- END Top Products and Latest Orders -->
@endsection

@push('scripts')
    <script>
        function get_data() {
            $.ajax({
                url: @json(route('admin.hospitals.get_data')),
                method: 'GET',
                success: function(response) {
                    $('#data-view').html(response);
                }
            });
        }

        $(document).ready(function() {
            get_data();
        });

        $('#division').change(function(e) {
            var divisionId = e.target.value; // Get the selected division id
            if (divisionId) { // Ensure divisionId is not empty
                $.ajax({
                    url: window.origin + '/api/v1/districts?division_id=' + divisionId,
                    method: 'get',
                    success: function(res) {
                        if (res.status === 'success') {
                            $('#district').empty(); // Clear previous district options

                            var container = document.getElementById('district');
                            addOption(container, 'Select Option', '', true); // Add placeholder
                            res.data.forEach((item) => {
                                addOption(container, item.title, item.id,
                                false); // Add district options
                            });
                        }
                    }
                });
            }
        });


        $('#district').change(function(e) {
            var districtId = e.target.value;
            $.ajax({
                url: window.origin + '/api/v1/upzillas?district_id=' + districtId,
                method: 'get',
                success: function(res) {
                    if (res.status === 'success') {
                        $('#upzilla').empty();

                        var container = document.getElementById('upzilla');
                        addOption(container, 'Select Option', '', true);
                        res.data.forEach((item, i) => {
                            addOption(container, item.title, item.id, false);
                        })
                    }
                }
            })
        })


        function addOption(container, text, value, selected) {
            var item = document.createElement('option');
            item.textContent = text;

            if (value) item.setAttribute('value', value);
            if (selected) item.setAttribute('selected', selected);

            container.appendChild(item);
        }
    </script>
@endpush
