<div class="modal-dialog modal-lg modal-dialog-popout" role="document">
    <div class="modal-content">
        <div class="block block-rounded block-themed block-transparent mb-0">
            <div class="block-header bg-gd-default">
                <h3 class="block-title">@lang('hospital.create_title')</h3>
                <div class="block-options">
                    <button type="button" class="btn-block-option" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fa fa-fw fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="block-content">
                <!-- Form Grid with Labels -->
                <form method="POST" class="submit-form" action="{{ route('admin.hospitals.store') }}">
                    @csrf
                    <div class="row">
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="Division">Division</label>
                                <div class="form_select">
                                    <select id="division" name="division" required>
                                        <option value="" selected>Select</option>
                                        @foreach ($divisions as $division)
                                            <option value="{{ $division->id }}">{{ $division->title ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="District">District/Municipality/Cantonment </label>
                                <div class="form_select">
                                    <select id="district" name="district" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <div class="form_group">
                                <label for="Upzilla">Upzilla/Pourashava</label>
                                <div class="form_select">
                                    <select id="upzilla" name="upzilla" required>
                                        <option value="" selected>Select</option>
                                    </select>
                                </div>
                            </div>
                        </div>



                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.title')</label>
                            <input type="text" class="form-control" name="title" value="{{ old('title') }}">
                        </div>
                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.title_bn')</label>
                            <input type="text" class="form-control" name="title_bn" value="{{ old('title_bn') }}">
                        </div>

                        <div class="col-12 col-md-6  mb-3">
                            <label class="form-label">@lang('hospital.code')</label>
                            <input type="text" class="form-control" name="code" value="{{ old('code') }}">
                        </div>
                    </div>


                    <button type="submit" class="btn btn-sm btn-outline-primary mb-3">
                        @lang('hospital.save_hospital')
                    </button>

                </form>
                <!-- END Form Grid with Labels -->
            </div>
            <div class="block-content block-content-full text-end bg-gray-lighter">
                <button type="button" class="btn btn-sm btn-danger" data-bs-dismiss="modal">@lang('common.close')</button>
            </div>
        </div>
    </div>
</div>
