@extends('admin.layouts.app')

@section('title')
    Gallery
@endsection



@section('content')
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mt-2 float-end" data-bs-toggle="modal" data-bs-target="#exampleModal">
        Add Gallery
    </button><br>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add Gallery</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('admin.gallerys.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div>
                            <label>Name:</label>
                            <input class="form-control" name="name" placeholder="Write a Name">
                        </div>
                        <div>
                            <label>Bangla Name:</label>
                            <input class="form-control" name="bn_name" placeholder="Write a bangla Name">
                        </div>

                        <div>
                            <label>Description:</label>
                            <textarea class="form-control" name="description" cols="30" rows="5"></textarea>
                        </div>
                        <div>
                            <label>Bangla Description:</label>
                            <textarea class="form-control" name="bn_description" cols="30" rows="5"></textarea>
                        </div>
                        <div>
                            <label>Image:</label>
                            <input class="form-control" name="image" type="file">
                        </div>
                        <div>
                            <label>Home Location:</label>
                            <input class="form-control" name="home_location" placeholder="Write a home location">
                        </div>
                        <div>
                            <label>Bangla Home Location:</label>
                            <input class="form-control" name="bn_home_location" placeholder="Write a bangla home location">
                        </div>
                        <div>
                            <label>Reference Name:</label>
                            <input class="form-control" name="reference_name" placeholder="Write a reference name">
                        </div>
                        <div>
                            <label>Bangla Reference Name:</label>
                            <input class="form-control" name="bn_reference_name"
                                placeholder="Write a bangla reference name">
                        </div>
                        <div>
                            <label>Reference Location:</label>
                            <input class="form-control" name="reference_location" placeholder="Write a home location">
                        </div>
                        <div>
                            <label>Bangla Reference Location:</label>
                            <input class="form-control" name="bn_reference_location" placeholder="Write a bangla home location">
                        </div>
                        <div class="d-flex gap-2">
                            <input type="checkbox" name="status" id="status">
                            <label for="status">Status :</label>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <br>


    {{-- table list starts --}}
    <div class="block-content block-content-full">
        <table id="example" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>User </th>
                    <th>Account Id</th>
                    <th>Home Location</th>
                    <th>Reference Name</th>
                    <th>Created At</th>
                    <th>Image</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($galleries->sortByDesc('created_at') as $gallery)
                    @php
                        $roleId = optional($gallery->user)->role_id;
                    @endphp
                    <tr>
                        <td>{{ $gallery->name }}</td>
                        <td>

                            @if ($roleId == 0)
                                User
                            @elseif ($roleId == 1)
                                Admin
                            @elseif ($roleId == 2)
                                Foundation
                            @elseif ($roleId == 3)
                                Hospital
                            @else
                                Unknown
                            @endif
                        </td>
                        <td>
                            <a
                                href="{{ route('admin.add-new-user.index', ['user_id' => $gallery->user_id]) }}">{{ $gallery->account_id }}</a>
                        </td>
                        <td>{{ $gallery->home_location }}</td>
                        <td>{{ $gallery->reference_name }}</td>
                        <td>{{ $gallery->created_at }}</td>

                        <td>
                            <form action="{{ route('admin.gallerys.toggleSeen', $gallery->id) }}" method="POST">
                                @csrf
                                @method('POST')
                                <button type="submit" class="btn mt-3 align-items-center"><img height="100"
                                        width="100" src="{{ asset($gallery->image) }}"></button>
                            </form>
                        </td>
                        <td>
                            @if ($gallery->seen)
                                <span class="btn btn-success">Seen</span>
                            @else
                                <span class="btn btn-secondary">Unseen</span>
                            @endif
                        </td>
                        <td>

                            <a href="{{ route('admin.gallerys.edit', $gallery->id) }}" class="btn btn-warning">Edit</a>
                            <form method="POST" action="{{ route('admin.gallerys.destroy', $gallery->id) }}"
                                style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>
    </div>
@endsection
