@extends('admin.layouts.app')

@section('title')
    Gallery Update
@endsection



@section('content')
    {{-- table list starts --}}
    <div class="block-content block-content-full">
        <form action="{{ route('admin.gallerys.update', $gallery->id) }}" method="post" enctype="multipart/form-data">
            @csrf
            @method('PUT')


            <div>
                <label>Name:</label>
                <input class="form-control" name="name" value="{{ $gallery->name }}" placeholder="Write a Name">
            </div>
            <div>
                <label>Bangla Name:</label>
                <input class="form-control" name="bn_name" value="{{ $gallery->bn_name }}" placeholder="Write a bangla Name">
            </div>

            <div>
                <label>Description:</label>
                <textarea class="form-control" name="description" cols="30" rows="5">{{ $gallery->bn_description }}</textarea>
            </div>
            <div>
                <label>Bangla Description:</label>
                <textarea class="form-control" name="bn_description" cols="30" rows="5">{{ $gallery->bn_description }}</textarea>
            </div>
            <div>
                <label>Image:</label>
                <input class="form-control" name="image" type="file">
                <img src="{{ asset($gallery->image) }}" alt="" style="height:80px;" class="img-fluid">
            </div>
            <div>
                <label>Home Location:</label>
                <input class="form-control" name="home_location" value="{{ $gallery->home_location }}"
                    placeholder="Write a home location">
            </div>
            <div>
                <label>Bangla Home Location:</label>
                <input class="form-control" name="bn_home_location" value="{{ $gallery->bn_home_location }}"
                    placeholder="Write a bangla home location">
            </div>
            <div>
                <label>Reference Name:</label>
                <input class="form-control" name="reference_name" value="{{ $gallery->reference_name }}"
                    placeholder="Write a reference name">
            </div>
            <div>
                <label>Bangla Reference Name:</label>
                <input class="form-control" name="bn_reference_name" value="{{ $gallery->bn_reference_name }}"
                    placeholder="Write a bangla reference name">
            </div>
            <div class="d-flex gap-2 align-items-center">
                <input type="checkbox" name="status" id="status" {{ $gallery->status ? 'checked' : '' }}>
                <label for="status">Active Status</label>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">update changes</button>
            </div>
        </form>
    </div>
    </div>
@endsection
