@extends('admin.layouts.app')

@section('title')
    New User
@endsection



@section('content')
    {{-- table list starts --}}
    <div class="block-content block-content-full">
        <form action="{{ route('admin.add-new-user.update', $data->id) }}" method="post" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div>
                <label>Name:</label>
                <input class="form-control" name="name" value="{{ $data->name }}">
            </div>
            <div>
                <label>Email:</label>
                <input class="form-control" name="email" value="{{ $data->name }}">
            </div>
            <div>
                <label>Phone:</label>
                <input class="form-control" name="phone" value="{{ $data->name }}">
            </div>
            <div>
                <label for="email_verified_at">Account Verify:</label>
                <div class="d-flex align-items-center justify-content-center gap-3">
                    <input type="checkbox" name="email_verified_at" id="email_verified_at" value="1">
                    <label>Active</label>
                </div>
            </div>
            <div>
                <label for="status">Status:</label>
                <div class="d-flex align-items-center justify-content-center gap-3">
                    <input type="checkbox" name="status" id="status" value="1">
                    <label>Active</label>
                </div>
            </div>
            <div>
                <label>Image:</label>
                <input class="form-control" name="image" type="file">
                <img src="{{ asset('developer') }}/{{ $data->image }}" alt="" style="height:80px;"
                    class="img-fluid">
            </div>


    </div>
    <div class="modal-footer">

        <button type="submit" class="btn btn-primary">update changes</button>
    </div>
    </form>
    </div>
@endsection
