@extends('admin.layouts.app')

@section('title')
    New Hospital
@endsection



@section('content')
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mt-2 float-end" data-bs-toggle="modal" data-bs-target="#exampleModal">
        Add New Hospital
    </button><br>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add New Hospital</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('admin.add-new-hospital.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div>
                            <label>Name:</label>
                            <input class="form-control" name="name" placeholder="Write a name">
                        </div>
                        <div>
                            <label>Email:</label>
                            <input class="form-control" name="email" placeholder="Write your position">
                        </div>
                        <div>
                            <label>Phone:</label>
                            <input class="form-control" name="mobile" placeholder="Write your position">
                        </div>
                        <div>
                            <label>Password:</label>
                            <input class="form-control" name="password" placeholder="Write your social media link">
                        </div>

                        <div>
                            <label for="status">Status:</label>
                            <div class="d-flex align-items-center justify-content-center gap-3">
                                <input type="checkbox" name="status" id="status" value="1">
                                <label>Active</label>
                            </div>
                        </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    <br>


    {{-- table list starts --}}
    <div class="block-content block-content-full">
        <table id="example" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>Account ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($hospitals as $hospital)
                    <tr @if (isset($selectedHospital) && $selectedHospital->id === $hospital->id) style="background-color: #f0f0f0;" @endif>
                        <td>{{ $hospital->account_id }}</td>
                        <td>{{ $hospital->name }}</td>
                        <td>{{ $hospital->email }}</td>
                        <td>{{ $hospital->mobile }}</td>
                        <td>
                            <a class="btn btn-warning" href="{{ route('admin.add-new-hospital.edit', $hospital->id) }}">Edit</a>
                            <form method="post" action="{{ route('admin.add-new-hospital.destroy', $hospital->id) }}"
                                style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
            {{-- <tfoot>
                <tr>
                    <th>Name</th>
                    <th>Bangla Name</th>
                    <th>Position</th>
                    <th>Bangla Position</th>
                    <th>Social Media Link</th>
                    <th>Description</th>
                    <th>Bangla Description</th>
                    <th>Image</th>
                    <th>Action</th>
                </tr>
            </tfoot> --}}
        </table>
    </div>


@endsection
