<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class HospitalSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if(!DB::table('hospitals')->where('id', 1)->exists()){
            DB::table('hospitals')->insert([
                'name' => 'hospital',
                'email' => 'hospital@gmail.com',
                'password' => Hash::make('hospital'),
                'email_verified_at' => now(),
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
    }
}