<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $this->call([
            AdminSeeder::class,
            BloodGroupSeeder::class,
            SuperAdminRoleSeeder::class,
            FoundationSeeder::class,
            HospitalSeeder::class,
            CountrySeeder::class,
            DivisionsTableSeeder::class,
            DistrictsTableSeeder::class,
            UpazillasTableSeeder::class,
            UnionsTableSeeder::class,
            WardsTableSeeder::class,
            VillagesTableSeeder::class,
            HospitalSeeder::class,
        ]);

        $predefinedUsers = [
            ['email' => env('SUPPER_ADMIN_EMAIL'), 'role_id' => 1],
            ['email' => env('ADMIN_EMAIL'), 'role_id' => 2],
            ['email' => env('STUDENT_EMAIL'), 'role_id' => 3],
            ['email' => env('TEACHER_EMAIL'), 'role_id' => 4],
            ['email' => env('GUARDIAN_EMAIL'), 'role_id' => 5],
        ];

        foreach ($predefinedUsers as $userData) {
            if (!User::where('email', $userData['email'])->exists()) {
                User::factory()->create([
                    'email' => $userData['email'],
                    'role_id' => $userData['role_id'],
                ]);
            }
        }

        Role::factory(5)->create();
    }
}