<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGalleriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('galleries', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('account_id')->nullable();
            $table->string('bn_name')->nullable();
            $table->boolean('seen')->default(false);
            $table->string('image')->nullable();
            $table->longText('description')->nullable();
            $table->longText('bn_description')->nullable();
            $table->string('home_location')->nullable();
            $table->string('bn_home_location')->nullable();
            $table->string('reference_name')->nullable();
            $table->string('bn_reference_name')->nullable();
            $table->string('reference_location')->nullable();
            $table->string('bn_reference_location')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('galleries');
    }
}
