<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFoundationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('foundations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('account_id')->nullable();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('last_otp')->unique()->nullable();
            $table->unsignedInteger('otp_sent_count')->nullable();
            $table->timestamp('otp_created_at')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('mobile')->nullable();
            $table->string('register_no')->nullable();
            $table->string('image')->nullable();
            $table->boolean('is_verified')->default(0)->comment('0 = not verified, 1 = verified');
            $table->string('blood_group')->nullable();
            $table->string('gender')->nullable();
            $table->foreignId('division_id')->nullable()->constrained('divisions')->onDelete('set null');
            $table->foreignId('district_id')->nullable()->constrained('districts')->onDelete('set null');
            $table->foreignId('upazilla_id')->nullable()->constrained('upazillas')->onDelete('set null');
            $table->foreignId('union_id')->nullable()->constrained('unions')->onDelete('set null');
            $table->string('ward_id')->nullable();
            $table->foreignId('village_id')->nullable()->constrained('villages')->onDelete('set null');
            $table->string('nid_no')->nullable();
            $table->string('birth_certificate_no')->nullable();
            $table->boolean('is_donnar')->default(0)->comment('0 = not donnar, 1=blood donar');
            $table->string('profession')->nullable();
            $table->string('status')->default(0)->nullable();
            $table->timestamps();

            // Add foreign key constraint
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('foundations');
    }
}