<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePourashavasVillagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pourashavas_villages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('division_id')->constrained('divisions')->onDelete('cascade');
            $table->foreignId('district_id')->constrained('districts')->onDelete('cascade');
            $table->foreignId('upazilla_id')->constrained('upazillas')->onDelete('cascade');
            $table->foreignId('pourashava_id')->constrained('pourashavas')->onDelete('cascade');
            $table->foreignId('pourashava_ward_id')->nullable()->constrained('pourashavas_wards')->onDelete('set null');
            $table->string('title')->comment('it should be village, place, colony');
            $table->string('title_bn')->nullable();
            $table->string('code')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('admins')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('pourashavas');
    }
}
