<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('account_id')->nullable();
            $table->string('role_id')->default(0)->nullable();
            $table->string('name');
            $table->string('email')->nullable()->unique();
            $table->string('phone')->nullable()->unique();
            $table->string('last_otp')->unique()->nullable();
            $table->unsignedInteger('otp_sent_count')->default(0);
            $table->timestamp('otp_created_at')->nullable(); // Removed the 'after' clause
            $table->timestamp('email_verified_at')->nullable();
            $table->string('status')->default(0)->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}