<?php

namespace App\Repository;

use App\Models\Profession;
use Illuminate\Support\Facades\Validator;

class ProfessionRepository
{
    public static function get()
    {
        $data = Profession::latest();

        if (auth('admin')->check()) {
            $data->accessible();
        }

        return $data->get();
    }

    public static function create($request)
    {
        $input = $request->except('_token');
        if (Profession::create($input)) {
            return response()->json(['success' => __('profession.create_message')]);

        } else {
            return response()->json(['error' => __('profession.error_message')]);
        }

    }

    public static function update($request, $id)
    {
        $validator = Validator::make($request->all(), [
            "title" => "required",
        ]);

        $input = $request->except('_token');

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()]);
        } else {

            if (Profession::find($id)->update($input)) {
                return response()->json(['success' => __('profession.update_message')]);

            } else {
                return response()->json(['error' => 'Data Does not insert.someting went to wrong. please try again!']);
            }
        }
    }

    public static function delete($id)
    {
        if (Profession::find($id)->delete()) {
            return response()->json(['success' => 'Profession deleted successfully done!']);

        } else {
            return response()->json(['error' => 'Data Does not deleted.someting went to wrong. please try again!']);
        }
    }

    public static function bluk_update($request)
    {
        $input = $request->only(['status']);

        if ($request->has('status') && $request->status == 1) {
            $input['status'] = 1;
        }

        if ($request->has('ids')) {
            $ids = $request->ids;
            foreach ($ids as $id) {
                Profession::find($id)->update($input);
            }

            return response()->json(['success' => 'Profession bulk changed successfully done!']);

        }

        return response()->json(['error' => 'Someting went to wrong. please try again!']);
    }

    public static function bluk_delete($request)
    {
        $ids = $request->ids;
        foreach ($ids as $id) {
            if ($id != null) {
                Profession::find($id)->delete();
            } else {
                return response()->json(['error' => 'Someting went to wrong. please try again!']);
            }
        }
        return response()->json(['success' => 'Profession deleted successfully done!']);
    }
}