<?php

namespace App\Repository;

use Exception;
use App\Models\Union;
use App\Models\District;
use App\Models\Pourashava;
use App\Models\Upazilla;
use App\Rules\UniqueTitle;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Validator;

class PourashavaRepository
{

    public static function get($request = null)
    {
        $pourashavas = Upazilla::orderBy('id', 'ASC')->with('pourashavas');
        if(isset($request->upazilla_id))
        {
            $pourashavas->where('id',$request->upazilla_id);
        }


       return $pourashavas->get();
    }

    public static function create($request)
    {
        if(is_array($request->title)){
            try{
                $upazilla = Upazilla::where('id', $request->upazilla_id)->first();
                if($upazilla != null){
                    for ($i=0; $i < count($request->title) ; $i++) {
                        Pourashava::create([
                            'title' => $request->title[$i],
                            'title_bn' => $request->title_bn[$i],
                            'upazilla_id' => $request->upazilla_id,
                            'district_id' => $upazilla->district_id,
                            'division_id' => $upazilla->division_id,
                        ]);
                    }
                }
                return response()->json(['success' => __('pourashava.create_message')]);
            }catch(Exception $exception){
                DB::rollBack();
                return response()->json(['error' => __('pourashava.create_error')]);
            }
        }
    }

    public static function update($request, $id)
    {
        $validator = Validator::make($request->all(),[
            "title" => "required",
        ]);

        $input = $request->except('_token');

        if($validator->fails()){
            return response()->json(['errors' => $validator->errors()->all()]);
        }else{

            if(Pourashava::find($id)->update($input)){
                return response()->json(['success' => __('pourashava.update_message')]);

            }else{
                return response()->json(['error' => __('pourashava.update_error')]);
            }
        }
    }


    public static function delete($id)
    {
        if(Pourashava::find($id)->delete()){
            return response()->json(['success' => __('pourashava.delete_message')]);

        }else{
            return response()->json(['error' => __('unionpourashava.delete_error')]);
        }
    }


    public static function bluk_update($request)
    {
        $input = $request->only(['status']);

        if($request->has('status') && $request->status == 1){
            $input['status'] = 1;
        }

        if($request->has('ids')){
            $ids = $request->ids;
            foreach($ids as $id){
                Pourashava::find($id)->update($input);
            }

            return response()->json(['success' => 'Pourashava bulk changed successfully done!']);

        }

        return response()->json(['error' => 'Someting went to wrong. please try again!']);
    }


    public static function bluk_delete($request)
    {
        $ids = $request->ids;
        foreach($ids as $id){
            if($id != null){
                Pourashava::find($id)->delete();
            }else{
                return response()->json(['error' => 'Someting went to wrong. please try again!']);
            }
        }
        return response()->json(['success' => 'Pourashava deleted successfully done!']);
    }
}