<?php

namespace App\Providers;

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(): void
    {
        $this->app->bind(
            'App\Interfaces\WardInterface',
            'App\Repository\WardRepository',
        );
        $this->app->bind(
            'App\Interfaces\VillageInterface',
            'App\Repository\VillageRepository',
        );

        Schema::defaultStringLength(191);
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        view()->composer('*', function ($view) {
            $view->with('lang', config('app.locale'));
        });
    }
}
