<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Profession extends Model
{
    use HasFactory;
    protected $fillable = ['title', 'title_bn','created_by'];
    public function scopeAccessible($query)
    {
        $user = auth()->guard('admin')->user();

        if ($user->profession_id === null) {
            return $query; // No filtering for super admin
        }

        return $query->where('id', $user->profession_id);
    }
}