<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;

class Foundation extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    protected $hidden = [
        'password',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'otp_created_at' => 'datetime',
    ];

    /**
     * Get the user that owns the foundation.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function foundationDesignation()
    {
        return $this->belongsTo(Foundation::class, 'foundation_id', 'id');
    }
}