<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TramsCondition;
use Illuminate\Http\Request;

class TramsConditionController extends Controller
{
    public function index()
    {
        $trams = TramsCondition::all();
        return view('admin.tram.index', compact('trams'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'bn_description' => 'nullable|string',
        ]);

        $tram = new TramsCondition();
        $tram->title = $validatedData['title'];
        $tram->description = $validatedData['description'];
        $tram->bn_title = $validatedData['bn_title'];
        $tram->bn_description = $validatedData['bn_description'];

        // Handling image upload
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/tram'), $imageName);
            $tram->image = 'admin/tram/' . $imageName;
        }

        $tram->status = $request->has('status') ? true : false;
        $tram->save();

        // Redirect with a success message
        return redirect()->route('admin.trams.index')->with('success', 'tram section created successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tram = TramsCondition::findOrFail($id);
        return view('admin.tram.edit', compact('tram'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'bn_description' => 'nullable|string',
        ]);

        // Find the existing tram record
        $tram = TramsCondition::findOrFail($id);

        // Update text fields
        $tram->title = $validatedData['title'];
        $tram->description = $validatedData['description'];
        $tram->bn_title = $validatedData['bn_title'];
        $tram->bn_description = $validatedData['bn_description'];

        // Check if a new image is uploaded
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            // Remove the old image if it exists
            if ($tram->image && file_exists(public_path($tram->image))) {
                unlink(public_path($tram->image));
            }

            // Upload the new image
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/tram'), $imageName);

            // Update the image path
            $tram->image = 'admin/tram/' . $imageName;
        }

        // Update the status
        $tram->status = $request->has('status') ? true : false;

        // Save the updated record
        $tram->save();

        // Redirect with a success message
        return redirect()->route('admin.trams.index')->with('success', 'tram section updated successfully');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tram = TramsCondition::findOrFail($id);
        if ($tram->image && file_exists(public_path($tram->image))) {
            unlink(public_path($tram->image));
        }

        $tram->delete();
        return redirect()->route('admin.trams.index')->with('success', 'tram section deleted successfully');
    }
}