<?php

namespace App\Http\Controllers\Admin;

use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Repository\PourashavaRepository;
use App\Http\Controllers\Controller;
use App\Http\Requests\PourashavaRequest;
use App\Models\Pourashava;
use App\Models\PourashavaTranslation;

class PourashavaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.pourashavas.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pourashavas.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PourashavaRequest $request)
    {
        return PourashavaRepository::create($request);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pourashava = Pourashava::findOrFail($id);
        return view('admin.pourashavas.edit', compact('pourashava'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return PourashavaRepository::update($request, $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return PourashavaRepository::delete($id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        return view('admin.pourashavas.delete', compact('id'));
    }



    public function get_data(Request $request)
    {
        $datas = PourashavaRepository::get();

        if ($request->has('division_id') || $request->has('district_id') || $request->has('upazilla_id')) {
            $datas = PourashavaRepository::get($request);
        }


        return view('admin.pourashavas.data', compact('datas'));
    }

    public function translation($id, $lang_id)
    {
        $pourashava = Pourashava::findOrFail($id);
        $language = Language::find($lang_id);

        if ($language != null) {
            $translation = PourashavaTranslation::where('pourashava_id', $id)->where('language_id', $lang_id)->first();
            return view('admin.pourashavas.translation', compact('pourashava', 'language', 'translation'));
        } else {
            return response()->json(['error' => 'You Have No Language Active.Someting went to wrong. please try again!']);
        }
    }

    public function save_translation(Request $request, $id, $lang_id)
    {

        $input = $request->except('_token');

        $input['pourashava_id'] = $id;
        $input['language_id'] = $lang_id;


        if (PourashavaTranslation::updateOrCreate(['language_id' => $lang_id, 'pourashava_id' => $id], $input)) {
            return response()->json(['success' => 'Pourashava Transalation updated successfully done!']);
        } else {
            return response()->json(['error' => 'Data Does not insert.someting went to wrong. please try again!']);
        }
    }


    public function all_translation(Request $request, $id)
    {
        $all_pourashavas = PourashavaRepository::get();

        if ($request->has('upazilla_id')) {
            $all_pourashavas = PourashavaRepository::get($request);
        }

        $language = Language::findOrFail($id);


        $pourashavas = $all_pourashavas->map(function ($pourashava) use ($language) {
            $translation = PourashavaTranslation::where('pourashava_id', $pourashava->id)->where('language_id', $language->id)->first();
            return [
                'id' => $pourashava->id,
                'title' => $translation->title ?? $pourashava->title,
            ];
        });


        return view('admin.pourashavas.all-translation', compact('pourashavas', 'language'));
    }


    public function save_all_translation(Request $request, $id)
    {

        $language_id = $id;
        $total_request = count($request->id);

        DB::beginTransaction();
        for ($i = 0; $i < $total_request; $i++) {
            $input['language_id'] = $language_id;
            $input['pourashava_id'] = $request->id[$i];
            $input['title'] = $request->title[$i];

            PourashavaTranslation::updateOrCreate(['language_id' => $language_id, 'pourashava_id' => $input['pourashava_id']], $input);
        }
        DB::commit();

        return response()->json(['success' => 'All Pourashava Transalation updated successfully done!']);
    }
}