<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Education;

class EducationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Education::all();
        return view('admin.education.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new Education;
        $image = $request->image;
        $imagename = time() . '.' . $image->getClientOriginalExtension();
        $request->image->move('education', $imagename);
        $data->image = $imagename;
        $data->name = $request->name;
        $data->bn_name = $request->bn_name;
        $data->text = $request->text;
        $data->bn_text = $request->bn_text;
        $data->save();

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Education::find($id); // Automatically throws a 404 error if not found
        return view('admin.education.edit', compact('data'));
    }

    public function update(Request $request, $id)
    {
        $data = Education::findOrFail($id); // Automatically throws a 404 error if not found

        if ($request->hasFile('image')) {
            // Delete the old image if it exists
            $oldImagePath = public_path('education/' . $data->image);
            if (file_exists($oldImagePath)) {
                unlink($oldImagePath);
            }

            // Upload the new image
            $file = $request->file('image');
            $imageName = time() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('education'), $imageName);
            $data->image = $imageName;
        }

        // Update other fields
        $data->name = $request->name;
        $data->bn_name = $request->bn_name;
        $data->text = $request->text;
        $data->bn_text = $request->bn_text;
        $data->save();

        return redirect()->route('admin.education.index')->with('success', 'Education record updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Education::find($id);
        if (file_exists('education/' . $data->image)) {
            unlink('education/' . $data->image);
        }
        $data->delete();
        return redirect()->back();
    }
}