<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\ContactUs;
use Illuminate\Http\Request;

class ContactUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contacts = ContactUs::all();
        return view('admin.contact.index', compact('contacts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'contact_phone' => 'nullable',
            'contact_email' => 'nullable',
            'contact_map_link' => 'nullable',
        ]);

        $contact = new ContactUs();
        $contact->title = $validatedData['title'];
        $contact->description = $validatedData['description'];
        $contact->bn_title = $validatedData['bn_title'];
        $contact->bn_description = $validatedData['bn_description'];
        $contact->contact_phone = $validatedData['contact_phone'];
        $contact->contact_email = $validatedData['contact_email'];
        $contact->contact_map_link = $validatedData['contact_map_link'];
        $contact->status = $request->has('status') ? true : false;
        $contact->save();

        // Redirect with a success message
        return redirect()->route('admin.contact.index')->with('success', 'Contact Us created successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $contact = ContactUs::findOrFail($id);
        return view('admin.contact.edit', compact('contact'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        // Find the existing About record
        $validatedData = $request->validate([
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'contact_phone' => 'nullable',
            'contact_email' => 'nullable',
            'contact_map_link' => 'nullable',
        ]);
        $contact = ContactUs::findOrFail($id);
        $contact->title = $validatedData['title'];
        $contact->description = $validatedData['description'];
        $contact->bn_title = $validatedData['bn_title'];
        $contact->bn_description = $validatedData['bn_description'];
        $contact->contact_phone = $validatedData['contact_phone'];
        $contact->contact_email = $validatedData['contact_email'];
        $contact->contact_map_link = $validatedData['contact_map_link'];
        $contact->status = $request->has('status') ? true : false;
        $contact->save();
        return redirect()->route('admin.contact.index')->with('success', 'Contact Us updated successfully');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $contact = ContactUs::findOrFail($id);
        $contact->delete();
        return redirect()->route('admin.contact.index')->with('success', 'Contact Us deleted successfully');
    }
}