<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Foundation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AddNewFoundationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $foundationId = $request->query('foundation_id');
        $foundations = Foundation::all();

        // Optional: Highlight or focus on the selected user
        $selectedFoundation = null;
        if ($foundationId) {
            $selectedFoundation = Foundation::find($foundationId);
        }
        return view('admin.add-new-foundation.index', compact('foundations', 'selectedFoundation'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'email' => 'nullable|email|unique:users,email',
            'name' => 'required',
            'mobile' => 'nullable',
            'password' => 'required',
        ]);
        $foundation = new Foundation();
        $foundation->email = $request->email;
        $foundation->name = $request->name;
        $foundation->mobile = $request->mobile;
        $foundation->password = Hash::make($request->password);
        $foundation->email_verified_at = $request->has('email_verified_at') ? now() : null;

        // Set status based on checkbox input (default to 0 if unchecked)
        $foundation->status = $request->has('status') ? 1 : 0;
        $foundation->save();

        // Generate and update account ID using the foundation ID
        $prefix = 'F';
        $generate = str_pad($foundation->id, 9, '0', STR_PAD_LEFT);
        $foundation->account_id = $prefix . $generate;
        $foundation->save();
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
