<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\About;
use Illuminate\Http\Request;

class AboutController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $abouts = About::all();
        return view('admin.about.index', compact('abouts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.about.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'bn_description' => 'nullable|string',
        ]);

        $about = new About();
        $about->title = $validatedData['title'];
        $about->description = $validatedData['description'];
        $about->bn_title = $validatedData['bn_title'];
        $about->bn_description = $validatedData['bn_description'];

        // Handling image upload
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/about'), $imageName);
            $about->image = 'admin/about/' . $imageName;
        }

        $about->status = $request->has('status') ? true : false;
        $about->save();

        // Redirect with a success message
        return redirect()->route('admin.abouts.index')->with('success', 'About section created successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $about = About::findOrFail($id);
        return view('admin.about.edit', compact('about'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'nullable|string',
            'description' => 'nullable|string',
            'bn_title' => 'nullable|string',
            'bn_description' => 'nullable|string',
        ]);

        // Find the existing About record
        $about = About::findOrFail($id);

        // Update text fields
        $about->title = $validatedData['title'];
        $about->description = $validatedData['description'];
        $about->bn_title = $validatedData['bn_title'];
        $about->bn_description = $validatedData['bn_description'];

        // Check if a new image is uploaded
        if ($request->hasFile('image') && $request->file('image')->isValid()) {
            // Remove the old image if it exists
            if ($about->image && file_exists(public_path($about->image))) {
                unlink(public_path($about->image));
            }

            // Upload the new image
            $image = $request->file('image');
            $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/about'), $imageName);

            // Update the image path
            $about->image = 'admin/about/' . $imageName;
        }

        // Update the status
        $about->status = $request->has('status') ? true : false;

        // Save the updated record
        $about->save();

        // Redirect with a success message
        return redirect()->route('admin.abouts.index')->with('success', 'About section updated successfully');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $about = About::findOrFail($id);
        if ($about->image && file_exists(public_path($about->image))) {
            unlink(public_path($about->image));
        }

        $about->delete();
        return redirect()->route('admin.abouts.index')->with('success', 'About section deleted successfully');
    }
}